# Interplanetary Invaders


*Computer game where you battle alien spiders across the solar system*

**Works for Windows and Linux**

## Installation

Requires:
 * python >= 3.7
 * pygame == 1.9.6
 * humanize

### Installation

```bash
python3 -m pip install interplanetary-invaders --user
```

### Execution

```bash
python3 -m interplanetary_invaders
```

**or**

```bash
interplanetary-invaders
```

**If you cloned the repository:**

```bash
python3 run_game.py
```

## Playing the game

 ![Gameplay Screenshot](https://github.com/nachomonkey/Interplanetary-Invaders/blob/master/wiki_data/screenshot_gameplay1.png  "Gameplay Screenshot")

After launching the game and selecting **Play**, a list of profiles appears. (Profiles are stored in the data directory). Once a profile
is selected, map mode is entered. After selecting a mission and continuing through the briefing and inventory menus,
a mission begins. The controls are **LEFT** and **RIGHT** to move (or **a** and **d**) and **SPACE**, **UP**, or **w** to fire.

At some point you will encounter an item (![Item](interplanetary_invaders/images/bitmap/animations/items/block/block1.png  "Item"))
After touching an item, it will disappear and go into your item storage ( ![Item storage](interplanetary_invaders/images/bitmap/itemHolder.png))
An icon representing the item will be visible in your item storage.
Press the number key on your keyboard that equals the one below the item's icon (i.e. If the item is in slot three, it
will have a "3" under it, and you must press the <**3**> key to activate it.)  You can also press <**Y**> to activate items.  The items vary from mission to mission (and planet to planet).

### Hints

When using the "2x Fire Rate" item without the "Auto Gun" item, it is easiest to fire faster
by pressing the **UP** key.

Press **F2** to take screenshots. Screenshots get stored in your *data* directory. The data directory's path gets printed
when the game launches.

# Acknowledgements

### Game Assets:

* Some images (described in the game's credits) are either directly used or modified versions of NASA images.
* [Flak Bursts sound](https://freesound.org/people/zimbot/sounds/209984/) (Modified) is by [zimbot](https://freesound.org/people/zimbot/) on https://freesound.org, under the Attribution License.
* Cash Register sound is by [kiddpark](https://freesound.org/people/kiddpark/) on https://freesound.org, under the Attribution License.
* The green alien crash sound is a modified version of a sound by [spoonsandlessspoons](https://freesound.org/people/spoonsandlessspoons/) on https://freesound.org, under the Attribution License.

### Other contributers:

* @XracerX

# License
This software is under the GNU GPLv3 License. See the [LICENSE](https://github.com/nachomonkey/Interplanetary-Invaders/blob/master/LICENSE) file for the full license.

